//***************************************************************************************
//	nRF8001 MSP430 Application
//
//
//  Built with Code Composer Studio v5.1.1
//***************************************************************************************

#include <msp430.h>
#include "hardware.h"
#include "spi.h"

#include "hal_aci_tl.h"
#include "aci.h"
#include "aci_evts.h"
#include "aci_cmds.h"
#include "aci_setup.h"
#include "lib_aci.h"
#include "services.h"
#include "ble_interface.h"

extern uint8_t rdynFlag;

//aci_struct that will contain
// total initial credits
// current credit
// current state of the aci (setup/standby/active/sleep)
// open remote pipe pending
// close remote pipe pending
// Current pipe available bitmap
// Current pipe closed bitmap
// Current connection interval, slave latency and link supervision timeout
// Current State of the the GATT client (Service Discovery)
// Status of the bond (R) Peer address
static struct aci_state_t aci_state;
static hal_aci_evt_t aci_data;
static hal_aci_data_t aci_cmd;


//
// _system_pre_init is called to disable the
// watchdog timer before CSTARTUP
// in case CSTARTUP takes too long to initialize
// variables and the watchdog fires.
//
int _system_pre_init(void)
{
	WDTCTL = WDTPW + WDTHOLD; // Stop Watchdog timer
	/*==================================*/
	/* Choose if segment initialization */
	/* should be done or not. */
	/* Return: 0 to omit initialization */
	/* 1 to run initialization */
	/*==================================*/
	return (1);
}

void initializeClocks(void);
void InitializeButton(void);
void InitializeLeds(void);
void resetDevice(void);



int main(void)
{
	WDTCTL = WDTPW + WDTHOLD;             // Stop watchdog timer

	initializeClocks();
	InitializeButton();
	InitializeLeds();

	//This will reset the nRF8001. ACI Device Started Event is generated by the nRF8001 device
	//as soon as the reset is complete
	hal_aci_tl_init();

	// Reset nRF8001
	resetDevice();
	_BIS_SR(GIE);

	begin_BLE(&aci_state);

	// Main application loop
	for (;;)
	{
		//_BIS_SR(LPM0_bits + GIE); // Enter LPM0 w/interrupt
		_nop();                   // For debugger
		//Not entirely sure if any of this if statement needs to be here...
		if(rdynFlag == 1)
		{
			rdynFlag = 0;

			m_rdy_line_handle();
		}
		pollACI(&aci_state, &aci_data, &aci_cmd);
	}

}

void initializeClocks()
{
	// Initialize system clocks MCLK and SMCLK to 16MHz

	/*
	BCSCTL1 = CALBC1_16MHZ;                    // Set range
	DCOCTL = CALDCO_16MHZ;
	BCSCTL2 &= ~(DIVS_3);                     // Set SMCLK = DCO
	*/
}

void InitializeButton(void)                 // Configure Push Button
{
	/*
	BUTTON_DIR &= ~BUTTON;
	BUTTON_OUT |= BUTTON;
	BUTTON_REN |= BUTTON;
	BUTTON_IES |= BUTTON;
	BUTTON_IFG &= ~BUTTON;
	BUTTON_IE |= BUTTON;
	*/
}


void InitializeLeds(void)
{
	/*
	LED_DIR |= LED1 + LED2;
	LED_OUT &= ~(LED1 + LED2);
	*/
}

/* *************************************************************
 * Port Interrupt for Button Press
 * 1. During standby mode: to exit and enter application mode
 * 2. During application mode: to recalibrate temp sensor
 * *********************************************************** */
#pragma vector=PORT1_VECTOR
__interrupt void PORT1_ISR(void)
{
	/*
	BUTTON_IFG = 0;
	BUTTON_IE &= ~BUTTON;            // Debounce
	WDTCTL = WDT_ADLY_250;
	IFG1 &= ~WDTIFG;                 // clear interrupt flag
	IE1 |= WDTIE;
	*/

	// Handle debounced press
}

// WDT Interrupt Service Routine used to de-bounce button press
#pragma vector=WDT_VECTOR
__interrupt void WDT_ISR(void)
{
	/*
    IE1 &= ~WDTIE;                   // disable interrupt
    IFG1 &= ~WDTIFG;                 // clear interrupt flag
    WDTCTL = WDTPW + WDTHOLD;        // put WDT back in hold state
    BUTTON_IE |= BUTTON;             // Debouncing complete
    */
}

// Resets the nRF8001 device, generating a Device Started event
void resetDevice()
{
	// Since MSP430 has input as High-Z, this
	// is the first time the device goes high
	nRF8001_RST_PDIR |= nRF8001_RST_PIN;
	nRF8001_RST_POUT |= nRF8001_RST_PIN;

	__delay_cycles(1000);
	P4OUT &= ~(nRF8001_RST_PIN);
	__delay_cycles(1000);
	nRF8001_RST_POUT |= nRF8001_RST_PIN;
	__delay_cycles(100);
}
